/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.PixelImage;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.TreeRow;
import ibm.nways.jdm.Watchable;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import mlsoft.mct.MlTree;

class ItemRow
extends TreeRow {
    private Image image;
    private MemoryImageSource memSource;
    private static BrowserApplet browserApp;
    private static Image baseStatusItemImage;
    private static PixelImage[] pixelImages;
    private static int imageWidth;
    private static int imageHeight;

    public ItemRow(MlTree mlTree, NavigationPoint navigationPoint) {
        super(mlTree, navigationPoint);
        Status status = navigationPoint.getStatus();
        if (status != null) {
            int n = status.getStatusType().toInt();
            PixelImage pixelImage = pixelImages[n];
            if (pixelImage == null) {
                ItemRow.pixelImages[n] = pixelImage = TreeRow.initPixelImage(baseStatusItemImage, mlTree, n);
            }
            this.memSource = new MemoryImageSource(imageWidth, imageHeight, pixelImage.pixels, 0, imageWidth);
            this.image = Toolkit.getDefaultToolkit().createImage(this.memSource);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void update(Watchable watchable, Object object) {
        if (this.image != null) {
            int n = ((Status)watchable).getStatusType().toInt();
            PixelImage pixelImage = pixelImages[n];
            if (pixelImage == null) {
                ItemRow.pixelImages[n] = pixelImage = TreeRow.initPixelImage(baseStatusItemImage, this.tree, n);
            }
            this.memSource.newPixels(pixelImage.pixels, ColorModel.getRGBdefault(), 0, imageWidth);
            this.image.flush();
            this.tree.repaint();
        }
    }

    public static void initImages(BrowserApplet browserApplet) {
        baseStatusItemImage = browserApplet.imageFrom(browserApplet, "/ibm/nways/jdm/StatusBall.gif");
        imageHeight = baseStatusItemImage.getHeight(browserApplet);
        imageWidth = baseStatusItemImage.getWidth(browserApplet);
        browserApp = browserApplet;
        pixelImages = new PixelImage[StatusType.NumDefined];
    }
}

